package gov.cms.grouper.snf.process;

import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.transfer.SnfClaim;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class SnfValidationTest {

  @Test
  public void validateAssessmentsTest() {
    SnfClaim snfClaim = new SnfClaim();
    snfClaim.addAssessment(new Assessment("A0310B", "A0310B", 1));
    snfClaim.addAssessment(new Assessment("B0700", "B0700", 2));
    Assert.assertTrue(SnfValidations.validateAssessments(snfClaim.getAssessments()));

    snfClaim.addAssessment(new Assessment("D0300", "D0300", -1));
    Assert.assertFalse(SnfValidations.validateAssessments(snfClaim.getAssessments()));


  }

  @Test
  public void validateDiagnosisPatternTest() {
    Assert.assertTrue(SnfValidations.validateDiagnosisPattern("D86.9^^^"));
    Assert.assertTrue(SnfValidations.validateDiagnosisPattern("K59.00^^"));
    Assert.assertTrue(SnfValidations.validateDiagnosisPattern("B20.^^^^"));

    Assert.assertFalse(SnfValidations.validateDiagnosisPattern("        "));
    Assert.assertFalse(SnfValidations.validateDiagnosisPattern("B2.0^^^^"));
    Assert.assertFalse(SnfValidations.validateDiagnosisPattern("B20^^^^^"));
    Assert.assertFalse(SnfValidations.validateDiagnosisPattern("^^^^^^^^"));
  }
}
